const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const CartSchema = new Schema({
    userId: {
        type: String,
    },
    items: [{
        productId: {
            type: String,
        },
        name: String,
        quantity: {
            type: Number,
            required: true,
            min: [1, 'Quantity can not be less then 1.'],
            default: 1
        },
        price: Number,
        image: {
            data: Buffer, // Store the filename as a string
            contentType: String,
          }
    }],
    bill: {
        type: Number,
        required: true,
        default: 0
    },
    discount:{
        type:Number,
        default:0
    }
});

module.exports = Cart = mongoose.model('cart',CartSchema);